import { StarXpandCommand } from "star-io10-web";

export class LabelSample04_For203dpiAnd300dpi_DrinkLabel3_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText(
              "No.${order_number}(${item_number}/${number_of_items}) ${datetime}\n",
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${product_name}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleHorizontalPositionTo(2.0)
                .actionPrintText("${item_list.detail}\n"),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText("${note}\n")
            .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
            .actionPrintText("No:${number}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "order_number" : 38,
    "item_number" : 1,
    "number_of_items" : 1,
    "datetime" : "19/10/30 18:55",
    "product_name" : "Star Tea/L",
    "item_list" : [
        {
            "detail" : "*Syrup/Regular"
        },
        {
            "detail" : "*Ice/Zero"
        },
        {
            "detail" : "*Pearl"
        }
    ],
    "note" : "カップ等の持ち帰り、\\n環境美化にご協力お願いします。\\n100020",
    "number" : "02-203854"
}`,
    );
  }
}
